(**
 * Delphi 2009 Scanning tool
 *
 * @package DelphiTwain Example
 * @link http://a32.me/
 * @author Constantin V. Bosneaga, Contact: ameoba32@gmail.com
**)
unit unMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, ShellCtrls, Buttons,
  delphitwain, iniFiles, Menus;

type
  TfmMain = class(TForm)
    Panel1: TPanel;
    cbSource: TComboBox;
    Label1: TLabel;
    Button1: TButton;
    tmScan: TTimer;
    sb: TStatusBar;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    Button2: TButton;
    pnAdditional: TPanel;
    Label2: TLabel;
    cbDPI: TComboBox;
    Label3: TLabel;
    cbColor: TComboBox;
    cbShowUI: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure tmScanTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    twain : TDelphiTwain;
    scanState : String;
    errorText : String;
    twainSource : Integer;
  public
    procedure OnTwainAcquire(Sender: TObject; const Index: Integer; Image: TBitmap; var Cancel: Boolean);
  end;

var
  fmMain: TfmMain;

implementation

uses Twain;

{$R *.dfm}

procedure TfmMain.Button1Click(Sender: TObject);
begin
  scanState := 'start';
end;

procedure TfmMain.Button2Click(Sender: TObject);
begin
  pnAdditional.Visible := Not pnAdditional.Visible;
end;

procedure TfmMain.FormCreate(Sender: TObject);
begin
  // Create twain driver
  twain := TDelphiTwain.Create(nil);
  Twain.OnTwainAcquire := OnTwainAcquire;

   //TODO: OnAcquireCancel
   Twain.TransferMode := ttmMemory;
   //Twain.Info.MinorVersion := 0;
//    Twain.Info.Language := tlUserLocale;
//   Twain.Info.CountryCode := 1;
//   Twain.Info.Groups := [tgControl, tgImage];
//   Twain.Info.VersionInfo := 'Application name';
//   Twain.Info.Manufacturer := 'Application manufacturer';
//   Twain.Info.ProductFamily := 'App product family';
//   Twain.Info.ProductName := 'App product name';
//   Twain.LibraryLoaded := False;
//   Twain.SourceManagerLoaded := False;
end;


procedure TfmMain.FormShow(Sender: TObject);
Var I : Integer;
begin
  if Twain.LoadLibrary then begin
    Twain.LoadSourceManager;
    for i  := 0 to Twain.SourceCount - 1 do
      cbSource.Items.Add( Twain.Source[i].ProductName );
//    NewSource := Twain.SelectSource;
    Twain.UnloadLibrary;
  end;

  cbSource.ItemIndex := 0;
  cbColor.ItemIndex := 2;
  cbDPI.ItemIndex := 2;
end;

procedure TfmMain.OnTwainAcquire(Sender: TObject; const Index: Integer;
  Image: TBitmap; var Cancel: Boolean);
begin
  Image1.Width := Image.Width;
  Image1.Height := Image.Height;
  with Image1.Picture.Bitmap do begin
    Assign(Image);
    PixelFormat := pf24bit;
  end;
end;

procedure TfmMain.tmScanTimer(Sender: TObject);
begin
  tmScan.Enabled := False;

  repeat
  if (scanState = 'idle') OR (scanState = '') then begin
    sb.SimpleText := '';
    break;
  end;

  if (scanState = 'error') then begin
    sb.SimpleText := 'Error: ' + errorText;
    break;
  end;

  if (scanState = 'start') then begin
    twainSource := cbSource.ItemIndex;
    if (twainSource = -1) then begin
      ScanState := 'error';
      errorText := 'No scanner selected';
      break;
    end;

    sb.SimpleText := 'Scanning...';
    {Load library, source manager and source}
    Twain.LoadLibrary;
    Twain.LoadSourceManager;

    Twain.Source[ twainSource ].Loaded := TRUE;
    Twain.Source[ twainSource].TransferMode := ttmMemory;

    // Add additional parameters
    if (pnAdditional.Visible) then begin
      if cbColor.ItemIndex = 0 then Twain.Source[ twainSource ].SetIPixelType(tbdBw);
      if cbColor.ItemIndex = 1 then Twain.Source[ twainSource ].SetIPixelType(tbdGray);
      if cbColor.ItemIndex = 2 then Twain.Source[ twainSource ].SetIPixelType(tbdRgb);

      Twain.Source[ twainSource ].SetIBitDepth( StrToInt(cbDPI.Items[cbDPI.ItemIndex]) );
      Twain.Source[ twainSource ].ShowUI := cbShowUI.Enabled;
    end;

    Twain.Source[ twainSource ].EnableSource(true, false);
    scanState := 'scan';
    break;
  end;

  if (scanState = 'scan') then begin
    if (not Twain.Source[twainSource].Enabled) then begin
      Twain.UnloadLibrary;
      scanState := 'done';
    end;
    break;
  end;

  if (scanState = 'done') then begin
    sb.SimpleText := 'Done.';
    scanState := 'idle';
    SetFocus;
    break;
  end;

  until false;

  tmScan.Enabled := True;
end;

end.
