<?
/**
 * Form class
 * 
 * Author: Constantin V. Bosneaga <constantin@bosneaga.com>
 * Date: 2012
 */


class A32_Form {
	private $content;
	private $value = array();
	
	
	function __construct($capture = true) {
		if ($capture) $this->start();
	}
	
	/**
	 * Starts
	 * 
	 */
	function start() {
		ob_start();
	}
	
	
	function end() {
		$this->content = ob_get_clean();
	}
	
	
	function render() {
		$output = $this->content;
		
		// Replace input/text values
		preg_match_all('~<(input|textarea)(.*?)/*>~ism', $this->content, $out);
		foreach($out[0] as $k => $v) {
			$arg = $this->__parse_arg($out[2][$k]);
			$tag = strtolower($out[1][$k]);
			if ($tag =='input' && !isset($arg['type'])) $arg['type'] = 'text';
			
			if (strtolower($arg['type']) == 'radio') {
				foreach($this->value as $var => $value)
					if ($arg['name'] == $var && $arg['value'] == $value) {
						$arg['checked'] = 1;
						$output = str_replace($out[0][$k], '<input '.$this->__combine_arg($arg).'/>', $output);
					}
			}

			if ($tag =='input' && strtolower($arg['type']) == 'text') {
				foreach($this->value as $var => $value)
					if ($arg['name'] == $var) {
						$arg['value'] = htmlspecialchars($value);
						$output = str_replace($out[0][$k], '<input '.$this->__combine_arg($arg).'/>', $output);
					}
			}
			
			if ($tag == 'textarea') {
				foreach($this->value as $var => $value)
					if ($arg['name'] == $var) {
						$output = str_replace($out[0][$k], '<textarea '.$this->__combine_arg($arg).'>'.htmlspecialchars($value).'</textarea>', $output);
					}
			}
			
			
		}
		print $output;
		
	}
	
	function set_array($arr) {
		/*
		foreach($arr as $k => $v) {
			if (is_array($v)) {
				foreach($v as $k2 => $v2)
				$this->value[ $k.'['.$k2.']' ] = $v2;
			} else {
				$this->value[ $k ] = $v;
			}
		}
		*/
		$this->value = array_merge($this->value, $arr);
	}
	
	function set($var, $value) {
		$this->value[ $var ] = $value;
	}
	
	function __parse_arg($html) {                                                                                                                          
		$result = array();                                                                                                                     
		preg_match_all('/(.*?)\s*=\s*[\'"](.*?)[\'"]/ism', $html, $out);                                                                             
		foreach($out[1] as $k => $v)
			$result[ strtolower(trim($out[1][$k])) ] = trim($out[2][$k]);                                                                        
		return $result;                                                                                                                              
	}            
	function __combine_arg($arg) {
		$result = '';
		foreach($arg as $k => $v)
			$result .= $k.'="'.$v.'" ';                                                                                                                          
		return trim($result);                                                                                                                              
	}            
	
	
}
