<?php
/*
Plugin Name: WP-BLN
Description: Inserts AD text into post at random positions
Author: Constantin V. Bosneaga
Version: 0.1
Author URI: http://a32.me/
*/

include "form.php";

class WP_BLN_Plugin {

	/**
	 * Init plugin
	 */	
	function init() {
		global $wpdb;
		
		add_action('admin_menu', array($this, 'wp_admin_menu'));
		add_action('publish_post', array($this, 'wp_publish_post'));
		add_action('wp_head', array($this, 'wp_head'));
		
		//add_filter('the_content', array($this, 'wp_the_content') );
		//wp_enqueue_style('bln-style', rtrim(get_option('siteurl'),'/') . '/'. PLUGINDIR . '/' . basename(dirname(__FILE__)) . '/style.css');
		
		// Init default options if not configured yet
		$data = get_option('bln_options');
		if (!$data) {
			$data = $this->default_options();
			update_option('bln_options', $data);			
		}
		
		// Options added later
		if ($data['css'] == '') {
			$tmp = $this->default_options();
			$data['css'] = $tmp['css'];
			update_option('bln_options', $data);			
		}
		
	}

	/**
	 * Registers admin menu for setup
	 */	
	function wp_admin_menu() {
		add_submenu_page('options-general.php', 'BLN Setup', 'BLN Setup', 'manage_options', 'bln_setup', array($this, 'wp_setup'));
	}

	/**
	 * Fires when post is published
	 */
	function wp_publish_post($post_id) {
		global $post;	
		
		remove_action('publish_post', array($this, 'wp_publish_post'));
		$this->inject_ad($post->ID);
	}
	/**
	 * Injects CSS into header
	 * 
	 */
	function wp_head() {
		$config = get_option('bln_options');
		echo '<style>'.$config['css'].'</style>';
	}

	/**
	 * ADMIN Setup page
	 * 
	 */	
	function wp_setup() {
		if ($_POST['populate_old_posts']) {
			$this->populate_old_posts();
		}

		// Save values on POST
		if (isset($_POST['version'])) {
			$data = $_POST;
			// Rearrange category and delete empty rows of categories
			$tmp = array();
			foreach($data['category']['name'] as $k => $v) {
				$item = array(
					'name' => $data['category']['name'][$k],
					'url' => $data['category']['url'][$k],
					'keyword' => $data['category']['keyword'][$k],
				);
				if ($k == 0 || $item['name'] != '') $tmp[] = $item;
			}
			$data['category'] = $tmp;
			$data['export'] = ''; // unset export field

			// Import of configuration
			if (!empty($_POST['import'])) {
				$data = unserialize(base64_decode(trim($_POST['import'])));
			}

			update_option('bln_options', $data);
		}

		// get current options
		$data = get_option('bln_options');
		if (!$data) {
			$data = $this->default_options();
			update_option('bln_options', $data);			
		}

		// Create form and values		
		$form = new A32_Form();
		require_once "setup.php";
		$form->end();

		$form->set_array($data);
		foreach($data['category'] as $k => $v) {
			$form->set('category[name]['.$k.']', $v['name']);
			$form->set('category[url]['.$k.']', $v['url']);
			$form->set('category[keyword]['.$k.']', $v['keyword']);
		}
		$form->set('export', base64_encode(serialize($data)));

		// Display form
		$form->render();
	}

	
	/**
	 * Creates plugin tables
	 * 
	 */
	function setup_tables() {
		global $wpdb;
		$wpdb->query("create table {$wpdb->prefix}bln_ad (fpost_id integer not null, fposition varchar(20), fhtml text, primary key(fpost_id) )");
	}
	
	
	/**
	 * Inserts AD into all posts
	 */
	function populate_old_posts() {
		$post_list = get_posts( array( 'numberposts' => '' ) );
		foreach($post_list as $post) {
			$this->inject_ad($post->ID);
		}
	}

	/**
	 * Inserts into post AD based of current config
	 *
	 */
	function inject_ad($post_id) {
		$config = get_option('bln_options');

		$post = get_post($post_id, ARRAY_A);

		// Something went wrong
		if (!is_array($post)) return;

		// Check if already embedded
		if (get_post_meta($post_id, 'ad_in_post', true) == 'yes') return;
		update_post_meta($post_id, 'ad_in_post', 'yes');
		// old way if (strpos($post['post_content'], 'id_ad_box') !== false) return;

		// Embedd into post
		$html = $this->generate_ad($config);

		// Detect position
		$position = $config['position'];
		if ($config['position'] == 'random') {
			$tmp = array('top', 'middle', 'bottom');
			$position = $tmp[ array_rand($tmp) ];
		}

		if ($position == 'top') $post['post_content'] =  $html.$post['post_content'];
		if ($position == 'bottom') $post['post_content'] = $post['post_content'].$html;
		if ($position == 'middle') {
			// Middle is tricky one
			$start = 0;
			$length = strlen($post['post_content']);
			while (($pos=strpos($post['post_content'], "\n", $start))  !== false) {
				$start = $pos+1;
				if ($pos >= $length/2) {
					$pos += 1;
					$post['post_content'] = substr($post['post_content'], 0, $pos).$html.substr($post['post_content'], $pos);
					break;
				}
			}
		}
		wp_update_post($post);
	}



	/**
	 * Generates completly random AD
	 * 
	 */
	function generate_ad($config) {
		list($usec, $sec) = explode(' ', microtime());
		srand((float) $sec + ((float) $usec * 100000));

		$result = '';
		
		// If AD format is random
		if ($config['format'] == 'random') {
			$tmp = array('box', 'ad');
			shuffle($tmp);
			$config['format'] = $tmp[0];
		}
		
		// AD format
		if ($config['format'] ==  'ad') {
			if ($config['ad_format'] == 'random') {
				$tmp = array('2link', '3link');
				shuffle($tmp);
				$config['ad_format'] = $tmp[0];
			}

			if ($config['ad_format'] == '2link') $result = '<div class="adbox adbox-2" id="id_ad_box">';
			if ($config['ad_format'] == '3link') $result = '<div class="adbox adbox-3" id="id_ad_box">';
			
			list($link, $url, $keyword) = $this->rnd_url_word($config);			
			$result .= "<div class='ad'><div class='keyword'><a href='{$link}'>{$keyword}</a></div><div class='url'><a href='{$url}'>{$url}</a></div></div>";
			list($link, $url, $keyword) = $this->rnd_url_word($config);			
			$result .= "<div class='ad'><div class='keyword'><a href='{$link}'>{$keyword}</a></div><div class='url'><a href='{$url}'>{$url}</a></div></div>";
			list($link, $url, $keyword) = $this->rnd_url_word($config);			
			if ($config['ad_format'] == '3link') $result .= "<div class='ad'><div class='keyword'><a href='{$link}'>{$keyword}</a></div><div class='url'><a href='{$url}'>{$url}</a></div></div>";
			$result .= '</div>';
		} 
		
		// Text Format
		if ($config['format'] ==  'box') {
			// Choose category for this BOX
			$category = $config['category'][ array_rand($config['category']) ];
			
			$result = $this->spintax($config['resource_box']);

			// Replace URLs and LINKs
			preg_match_all('/%(URL|LINK)(\d*)%/', $result, $out );
			foreach($out[0] as $k => $v) {
				list($link, $url, $keyword) = $this->rnd_url_word($config);

				$result = str_replace('%LINK'.$out[2][$k].'%', '<a href="'.$link.'">'.$keyword.'</a>', $result);
				$result = str_replace('%URL'.$out[2][$k].'%', '<a href="'.$url.'">'.$url.'</a>', $result);

				/*
				if ($out[1][$k] == 'LINK')
					$result = str_replace($out[0][$k], '<a href="'.$link.'">'.$keyword.'</a>', $result);
				if ($out[1][$k] == 'URL')

					$result = str_replace($out[0][$k], '<a href="'.$url.'">'.$url.'</a>', $result);
				*/
			}
			
			$result = '<p id="id_ad_box">'.$result.'</p>';
		}
		
		return $result;
	}

	/**
	 * Returns random LINK, URL, Keyword
	 */
	function rnd_url_word($config, $category = false) {
		if (!$category) $category = $config['category'][ array_rand($config['category']) ];
		$link = $this->spintax($category['url']);
		$keyword = $this->spintax($category['keyword']);
		$tmp = parse_url($link);
		$url = $tmp['scheme'].'://'.$tmp['host'].'/';
		
		return array($link, $url, $keyword);
	} 
	

	/**
	 * Return random spinning text from template like below
	 * This {article|report} {provided|donated} by %URL%, {visit|go to} their {site|website} for more {info|advice|information} on %LINK1% and %LINK2%.
	 */
	function spintax($text) {
		
		preg_match_all('/{(.*?)}/', $text, $out);
		foreach($out[0] as $k => $v) {
			$options = explode('|',$out[1][$k]);
			$tmp = array_rand($options);
			$tmp = $options[$tmp];
			$text = str_replace($out[0][$k], $tmp, $text);
		}
		return $text;
	}
	
	/**
	 * Default values for first plugin install
	 * 
	 */
	function default_options() {
		return array(
			'position' => 'random',
			'format' => 'random',
			'category' => array(
				array(
					'name' => 'Category 1',
					'url' => '{URL1|URL2|URL3}',
					'keyword' => '{keyword1|keyword2|keyword3}',
				)
			),
			'resource_box' => 'This {article|report} {provided|donated} by %URL%, {visit|go to} their {site|website} for more {info|advice|information} on %LINK%.',
			'ad_format' => 'random',
			
			'kw_color' => '#FF0000',
			'url_color' => '#FFFF00',
			'brd_color' => '#000000',
			'css' => '/* Colors */
.adbox {
	border:1px solid #000000;
	overflow:auto;
}
.adbox .url a {
	color: #FFFF00;
}
.adbox .keyword a {
	color: #FF0000;
}


/* Sizes */
.adbox-2 {width:500px;}	
.adbox-2 .ad {width:240px;}

.adbox-3 {width:600px;}
.adbox-3 .ad {width:160px;}

.ad {float:left;}
			'
		);
	}

}

$plugin_instance = new WP_BLN_Plugin();
$plugin_instance->init();

